/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.problem;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.base.pa.fedc.ConsoleFEDCKey;
import com.ibm.hwmca.base.pa.fru.HmcFruList;
import com.ibm.hwmca.base.pa.fru.HmcFruResolver;
import com.ibm.hwmca.base.pa.system.RemoteConsoleSystem;
import com.ibm.hwmca.base.remsrv.RemoteServiceData;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.domain.Domain;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogEntryId;
import com.ibm.hwmca.fw.pa.ProblemAnalysisException;
import com.ibm.hwmca.fw.pa.fedc.FEDCKey;
import com.ibm.hwmca.fw.pa.problem.ProblemClosingException;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.problem.ProblemOpeningException;
import com.ibm.hwmca.fw.pa.problem.ProblemReporter;
import com.ibm.hwmca.fw.pa.problem.history.HistoryEntry;
import com.ibm.hwmca.fw.pa.problem.history.ServiceHistory;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rsf.RemoteSupportFacility;
import com.ibm.hwmca.fw.rsf.RsfManager;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLEncodeableArrayList;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.CommonDataEvent;
import com.ibm.hwmca.xfw.pa.fru.CommonFruList;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.AnalysisData;
import com.ibm.hwmca.xfw.pa.problem.KeyValuePairing;
import com.ibm.hwmca.xfw.pa.problem.ProblemData;
import com.ibm.hwmca.xfw.pa.problem.RSFData;
import com.ibm.hwmca.xfw.pa.problem.SurveillanceLinkFailure;
import com.ibm.hwmca.xfw.pa.problem.XFrameProblem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import com.ibm.hwmca.xfw.pa.util.CeComment;
import com.ibm.hwmca.xfw.pa.util.CommonPaLogger;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import com.ibm.hwmca.xfw.panel.CaptionValuePairing;
import com.ibm.hwmca.xfw.panel.NonLocalizablePanelValue;
import com.ibm.hwmca.xfw.panel.PanelValue;
import java.beans.PropertyVetoException;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Node;

public class CommonProblem
extends XFrameProblem
implements Persistable {
    private static final String TRACE_MASKT = "XPACPROT";
    private static final String TRACE_MASKF = "XPACPROF";
    private static final String TRACE_MASKD = "XPACPROD";
    private static final boolean UNIT_TEST = true;
    private Object contextObject = null;
    protected PASystem reportingRemoteMachineSystem = null;
    protected PASystem primaryAnalyzingConsoleSystem = null;
    protected PASystem failingSystem = null;
    protected PASystem secondaryReportingSystem = null;

    public CommonProblem() {
        this("Common Problem");
        Trace.trace(TRACE_MASKD, "<--> CommonProblem.ctor()");
    }

    public CommonProblem(Node xfProblem) {
        super(xfProblem);
    }

    public CommonProblem(String description) {
        super(description);
        ProblemData initProblemData = new ProblemData();
        RSFData initRSFData = new RSFData();
        AnalysisData initAnalysisData = new AnalysisData();
        ServiceHistory serviceHistory = new ServiceHistory();
        this.setProblemData(initProblemData);
        this.setRSFData(initRSFData);
        this.setAnalysisData(initAnalysisData);
        this.setServiceHistory(serviceHistory);
        this.getProblemData().add("pdc_PROBLEM_ORIGIN", "NATIVE_LOCAL");
    }

    public CommonProblem(PersistentData data) throws PersistenceException {
        super(((CommonProblemPersistentData)data).superClassPersistentData);
        if (((CommonProblemPersistentData)data).rrmsPersistentData != null) {
            this.reportingRemoteMachineSystem = (PASystem)PersistenceManager.getPersistenceManager().containedFormToObject(((CommonProblemPersistentData)data).rrmsPersistentData);
        }
        if (((CommonProblemPersistentData)data).pacsPersistentData != null) {
            this.primaryAnalyzingConsoleSystem = (PASystem)PersistenceManager.getPersistenceManager().containedFormToObject(((CommonProblemPersistentData)data).pacsPersistentData);
        }
        if (((CommonProblemPersistentData)data).fsPersistentData != null) {
            this.failingSystem = (PASystem)PersistenceManager.getPersistenceManager().containedFormToObject(((CommonProblemPersistentData)data).fsPersistentData);
        }
        this.linkCPRemoteSystems();
        if (this.reportingRemoteMachineSystem != null) {
            Trace.trace(TRACE_MASKD, "reportingRemoteMachineSystem=" + this.reportingRemoteMachineSystem);
        } else {
            Trace.trace(TRACE_MASKD, "reportingRemoteMachineSystem=not set");
        }
        if (this.primaryAnalyzingConsoleSystem != null) {
            Trace.trace(TRACE_MASKD, "primaryAnalyzingConsoleSystem=" + this.primaryAnalyzingConsoleSystem);
        } else {
            Trace.trace(TRACE_MASKD, "primaryAnalyzingConsoleSystem=not set");
        }
        if (this.failingSystem != null) {
            Trace.trace(TRACE_MASKD, "failingSystem=" + this.failingSystem);
        } else {
            Trace.trace(TRACE_MASKD, "failingSystem=not set");
        }
    }

    public void fromXML(Node valueNode) {
        super.fromXML(valueNode);
        this.linkCPRemoteSystems();
    }

    public PersistentData getPersistentData() {
        CommonProblemPersistentData persistentData = new CommonProblemPersistentData();
        persistentData.superClassPersistentData = super.getPersistentData();
        if (this.reportingRemoteMachineSystem != null) {
            persistentData.rrmsPersistentData = PersistenceManager.getPersistenceManager().objectToContainedForm(this.reportingRemoteMachineSystem);
        }
        if (this.primaryAnalyzingConsoleSystem != null) {
            persistentData.pacsPersistentData = PersistenceManager.getPersistenceManager().objectToContainedForm(this.primaryAnalyzingConsoleSystem);
        }
        if (this.failingSystem != null) {
            persistentData.fsPersistentData = PersistenceManager.getPersistenceManager().objectToContainedForm(this.failingSystem);
        }
        return persistentData;
    }

    private void linkCPRemoteSystems() {
        Trace.trace(TRACE_MASKD, "--> linkCPRemoteSystems");
        RemoteSystemManager rsm = RemoteSystemManager.getRemoteSystemManager();
        if (rsm != null) {
            RemoteSystem knownSys;
            if (this.reportingRemoteMachineSystem != null && this.reportingRemoteMachineSystem instanceof RemoteSystem) {
                knownSys = rsm.getKnownSystem((RemoteSystem)this.reportingRemoteMachineSystem);
                if (knownSys != null) {
                    Trace.trace(TRACE_MASKD, "Associating reportingRemoteMachineSystem with RemoteSystemManager reference [" + knownSys.getUniqueKey() + "]");
                    this.reportingRemoteMachineSystem = knownSys;
                } else {
                    Trace.trace(TRACE_MASKT, "Couldn't find reportingRemoteMachineSystem (" + this.reportingRemoteMachineSystem + ") in RemoteSystemManager - this might be a problem!");
                }
            }
            if (this.failingSystem != null && this.failingSystem instanceof RemoteSystem) {
                knownSys = rsm.getKnownSystem((RemoteSystem)this.failingSystem);
                if (knownSys != null) {
                    Trace.trace(TRACE_MASKD, "Associating failingSystem with RemoteSystemManager reference [" + knownSys.getUniqueKey() + "]");
                    this.failingSystem = knownSys;
                } else {
                    Trace.trace(TRACE_MASKT, "Couldn't find failingSystem (" + this.failingSystem + ") in RemoteSystemManager - this might be a problem!");
                }
            }
        }
        Trace.trace(TRACE_MASKD, "<-- linkCPRemoteSystems");
    }

    public void setPrimaryDataEvent(CommonDataEvent dataEvent) {
        this.getMetaData().setMeta("pdc_EVENT", dataEvent);
        this.setDomainId(dataEvent.getDomainId());
        this.getProblemData().add("pdc_EVENT_ID", dataEvent.getEventId());
    }

    public CommonDataEvent getPrimaryDataEvent() {
        CommonDataEvent cde = (CommonDataEvent)this.getMetaData().getMeta("pdc_EVENT");
        if (cde == null) {
            String eventId = (String)this.getProblemData().get("pdc_EVENT_ID");
            if (eventId == null) {
                Trace.trace(TRACE_MASKD, "there is no primary data event set for this problem");
                return null;
            }
            cde = this.restoreEvent(eventId);
            if (cde != null) {
                this.getMetaData().setMeta("pdc_EVENT", cde);
                Trace.trace(TRACE_MASKD, "restore created this cde" + cde.getEventId());
            }
        }
        if (cde == null) {
            Trace.trace(TRACE_MASKD, "returning null cde");
        } else {
            Trace.trace(TRACE_MASKD, "returning a cde");
        }
        return cde;
    }

    public DomainIdentifier getDomainId() {
        String domid = (String)this.getProblemData().get("pdc_DOMAIN_ID");
        if (domid == null) {
            return null;
        }
        return new DomainIdentifier(domid);
    }

    public void setDomainId(DomainIdentifier domid) {
        String domainID = (String)this.getProblemData().get("pdc_DOMAIN_ID");
        if (domainID == null) {
            this.getProblemData().add("pdc_DOMAIN_ID", domid.getDID());
        } else {
            this.getProblemData().remove("pdc_DOMAIN_ID");
            this.getProblemData().add("pdc_DOMAIN_ID", domid.getDID());
        }
    }

    public Domain getDomain() {
        DomainIdentifier did = this.getDomainId();
        if (did == null) {
            return null;
        }
        return DomainManager.getDomainManager().get(did);
    }

    private CommonDataEvent restoreEvent(String evtId) {
        CommonDataEvent cde = CommonDataEvent.rebuildEvent(this, evtId);
        if (cde == null) {
            Trace.trace(TRACE_MASKT, "could not rebuild data event");
            return null;
        }
        LogEntryId logId = cde.getConsoleLogId();
        if (logId == null) {
            Trace.trace(TRACE_MASKT, "no log identifier for event - data unset");
            return cde;
        }
        try {
            Log log = Log.retrieve(logId);
            if (log == null) {
                return null;
            }
            cde.setData(log);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "could not retrieve log data  - data unset");
        }
        return cde;
    }

    public void addSecondaryDataEvent(CommonDataEvent dataEvent) {
        ArrayList<CommonDataEvent> metaEventList = (ArrayList<CommonDataEvent>)this.getMetaData().getMeta("pdc_SEC_EVENT_LIST");
        if (metaEventList == null) {
            metaEventList = new ArrayList<CommonDataEvent>();
            this.getMetaData().setMeta("pdc_SEC_EVENT_LIST", metaEventList);
        }
        metaEventList.add(dataEvent);
        ArrayList<String> probEventList = (ArrayList<String>)this.getProblemData().get("pdc_SEC_EVENT_ID_LIST");
        if (probEventList == null) {
            probEventList = new ArrayList<String>();
            this.getProblemData().add("pdc_SEC_EVENT_ID_LIST", probEventList);
        }
        probEventList.add(dataEvent.getEventId());
    }

    public void addSecondaryDataEvent(List inputList) {
        Iterator listIt = inputList.iterator();
        while (listIt.hasNext()) {
            Object dataEvent = listIt.next();
            if (!(dataEvent instanceof CommonDataEvent)) continue;
            this.addSecondaryDataEvent((CommonDataEvent)dataEvent);
        }
    }

    public List getSecondaryDataEventList() {
        ArrayList<CommonDataEvent> metaEventList = (ArrayList<CommonDataEvent>)this.getMetaData().getMeta("pdc_SEC_EVENT_LIST");
        if (metaEventList == null) {
            Trace.trace(TRACE_MASKD, "ProblemDataConstants.SEC_EVENT_LIST was null  ");
            List probEventList = (List)this.getProblemData().get("pdc_SEC_EVENT_ID_LIST");
            if (probEventList == null) {
                Trace.trace(TRACE_MASKD, "ProblemDataConstants.SEC_EVENT_ID_LIST was null");
                Trace.trace(TRACE_MASKD, "there are no secondary data events set for this problem ");
                return null;
            }
            metaEventList = new ArrayList<CommonDataEvent>();
            String eventId = null;
            CommonDataEvent cde = null;
            Iterator idIter = probEventList.iterator();
            while (idIter.hasNext()) {
                eventId = (String)idIter.next();
                cde = this.restoreEvent(eventId);
                if (cde == null) continue;
                metaEventList.add(cde);
            }
            if (metaEventList.size() > 0) {
                this.getMetaData().setMeta("pdc_SEC_EVENT_LIST", metaEventList);
                Trace.trace(TRACE_MASKD, "added event from restoreEvent ");
            }
        }
        return metaEventList;
    }

    public boolean isGenerateAttention() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_GENERATE_ATTENTION");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return true");
        return true;
    }

    public void setGenerateAttention(boolean attention) {
        this.getProblemData().add("pdc_GENERATE_ATTENTION", new Boolean(attention));
    }

    public boolean isCallHome() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_CALL_HOME");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return true");
        return true;
    }

    public void setCallHome(boolean callHome) {
        this.getProblemData().add("pdc_CALL_HOME", new Boolean(callHome));
    }

    public boolean isNotifyCustomer() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_NOTIFY_CUSTOMER");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return true");
        return true;
    }

    public void setServiceAuthorized(boolean serviceAuthorized) {
        this.getProblemData().add("pdc_SERV_AUTHORIZED", new Boolean(serviceAuthorized));
    }

    public boolean isServiceAuthorized() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_SERV_AUTHORIZED");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return false");
        return false;
    }

    public void setNotifyCustomer(boolean notifyCustomer) {
        this.getProblemData().add("pdc_NOTIFY_CUSTOMER", new Boolean(notifyCustomer));
    }

    public boolean isCollectFFDC() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_COLLECT_FFDC");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return true");
        return true;
    }

    public void setCollectFFDC(boolean collectFFDC) {
        this.getProblemData().add("pdc_COLLECT_FFDC", new Boolean(collectFFDC));
    }

    public String getFFDCLocation() {
        return (String)this.getProblemData().get("pdc_FFDC_PATH");
    }

    public void setFFDCLocation(String FFDCLocation) {
        this.getProblemData().add("pdc_FFDC_PATH", FFDCLocation);
    }

    public String getFFDCName() {
        return (String)this.getProblemData().get("pdc_FFDC_NAME");
    }

    public void setFFDCName(String FFDCName) {
        this.getProblemData().add("pdc_FFDC_NAME", FFDCName);
    }

    public boolean isDelayed() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_DELAYED_LOG");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return true");
        return false;
    }

    public void setDelayed(boolean delayed) {
        this.getProblemData().add("pdc_DELAYED_LOG", new Boolean(delayed));
    }

    public void setRefcode(String refcode) {
        this.getProblemData().add("pdc_REFCODE", refcode);
    }

    public String getRefcode() {
        String src = (String)this.getProblemData().get("pdc_REFCODE");
        if (src == null) {
            return new String();
        }
        int len = src.length();
        if (len <= 8) {
            return src;
        }
        return src.substring(0, 8);
    }

    public String getSRC() {
        return (String)this.getProblemData().get("pdc_REFCODE");
    }

    public void addAssociatedFile(String fileName) {
        List fileList = (List)this.getProblemData().get("pdc_ASSOC_FILE_LIST");
        if (fileList != null) {
            fileList.add(fileName);
        } else {
            fileList = new XMLEncodeableArrayList("Associated File List");
            fileList.add(fileName);
            this.getProblemData().add("pdc_ASSOC_FILE_LIST", fileList);
        }
    }

    public void addAssociatedFile(List inputList) {
        List fileList = (List)this.getProblemData().get("pdc_ASSOC_FILE_LIST");
        if (fileList != null) {
            fileList.addAll(inputList);
        } else {
            fileList = new XMLEncodeableArrayList("Associated File List");
            fileList.addAll(inputList);
            this.getProblemData().add("pdc_ASSOC_FILE_LIST", fileList);
        }
    }

    public List getAssociatedFileList() {
        return (List)this.getProblemData().get("pdc_ASSOC_FILE_LIST");
    }

    public void addProblemDataSet(String fileName) {
        List fileList = (List)this.getProblemData().get("pdc_PSD_LIST");
        if (fileList != null) {
            fileList.add(fileName);
        } else {
            fileList = new XMLEncodeableArrayList("EED File List");
            fileList.add(fileName);
            this.getProblemData().add("pdc_PSD_LIST", fileList);
        }
    }

    public void addProblemDataSet(ProblemDataDescriptor fileName) {
        List fileList = (List)this.getProblemData().get("pdc_PSD_LIST");
        if (fileList != null) {
            fileList.add(fileName);
        } else {
            fileList = new XMLEncodeableArrayList("EED File List");
            fileList.add(fileName);
            this.getProblemData().add("pdc_PSD_LIST", fileList);
        }
    }

    public List getEEDContents() {
        ArrayList<ProblemDataDescriptor> returnList = new ArrayList<ProblemDataDescriptor>();
        List dataSetList = this.getProblemDataSet();
        if (dataSetList != null) {
            Iterator it = dataSetList.iterator();
            while (it.hasNext()) {
                ProblemDataDescriptor pdd = (ProblemDataDescriptor)it.next();
                if (pdd.getType() != "INIT_CALL_HOME_DATA_SET") continue;
                try {
                    ZipFile zippy = new ZipFile(pdd.getFileLocation());
                    if (zippy == null) continue;
                    Enumeration<? extends ZipEntry> enumeration = zippy.entries();
                    while (enumeration.hasMoreElements()) {
                        File file = (File)((Object)enumeration.nextElement());
                        ProblemDataDescriptor thePDD = new ProblemDataDescriptor();
                        thePDD.setLocation(zippy.getName());
                        thePDD.setName(file.getName());
                        returnList.add(thePDD);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return returnList;
    }

    public void addProblemDataSet(List inputList) {
        List fileList = (List)this.getProblemData().get("pdc_PSD_LIST");
        if (fileList != null) {
            fileList.addAll(inputList);
        } else {
            fileList = new XMLEncodeableArrayList("EED File List");
            fileList.addAll(inputList);
            this.getProblemData().add("pdc_PSD_LIST", fileList);
        }
    }

    public List getProblemDataSet() {
        return (List)this.getProblemData().get("pdc_PSD_LIST");
    }

    public void setSecondaryRefcode(String refcode) {
        this.getProblemData().add("pdc_SECONDARY_REFCODE", refcode);
    }

    public String getSecondaryRefcode() {
        return (String)this.getProblemData().get("pdc_SECONDARY_REFCODE");
    }

    public void setPMH(String pmh) {
        this.getProblemData().add("pdc_PMH", pmh);
    }

    public String getPMH() {
        return (String)this.getProblemData().get("pdc_PMH");
    }

    public void setUnavailableServices(long unavail) {
        this.getProblemData().add("pdc_UNAVAIL_SERVICES", new Long(unavail));
    }

    public long getUnavailableServices() {
        if (this.getProblemData().get("pdc_UNAVAIL_SERVICES") != null) {
            return (Long)this.getProblemData().get("pdc_UNAVAIL_SERVICES");
        }
        return 0L;
    }

    public String getExtension() {
        return (String)this.getProblemData().get("pdc_EXTENSION");
    }

    public void setExtension(String extension) {
        this.getProblemData().add("pdc_EXTENSION", extension);
    }

    public String getSecondaryExtension() {
        return (String)this.getProblemData().get("pdc_SECONDARY_EXTENSION");
    }

    public void setSecondaryExtension(String extension) {
        this.getProblemData().add("pdc_SECONDARY_EXTENSION", extension);
    }

    public String getProblemDataString() {
        return (String)this.getProblemData().get("pdc_PROBLEM_DATA");
    }

    public void setProblemDataString(String problemData) {
        Trace.trace(TRACE_MASKD, "problem data to set is " + problemData);
        this.getProblemData().add("pdc_PROBLEM_DATA", problemData);
    }

    public String getProblemType() {
        return (String)this.getProblemData().get("pdc_PROBLEM_TYPE");
    }

    public void setProblemType(String problemType) {
        Trace.trace(TRACE_MASKD, "setting problem type to be " + problemType);
        this.getProblemData().add("pdc_PROBLEM_TYPE", problemType);
    }

    public String getService() {
        return (String)this.getProblemData().get("pdc_SERVICE");
    }

    public void setService(String service) {
        this.getProblemData().add("pdc_SERVICE", service);
    }

    public void setRSFEnabled(boolean rsfEnabled) {
        this.getProblemData().add("pdc_RSF_ENABLED", new Boolean(rsfEnabled));
    }

    public void setRSFEnabled(int rsfEnabled) {
        Boolean boolEnabled = rsfEnabled != 0 ? new Boolean(true) : new Boolean(false);
        this.getProblemData().add("pdc_RSF_ENABLED", boolEnabled);
    }

    public boolean isRSFEnabled() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_RSF_ENABLED");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return false");
        return false;
    }

    public void setTransmit(boolean transmit) {
        this.getProblemData().add("pdc_TRANSMIT_VIA_RSF", new Boolean(transmit));
    }

    public boolean isTransmit() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_TRANSMIT_VIA_RSF");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return true");
        return true;
    }

    public String getCustomerContact() {
        return (String)this.getProblemData().get("pdc_CUSTOMER_CONTACT");
    }

    public void setCustomerContact(String customerContact) {
        this.getProblemData().add("pdc_CUSTOMER_CONTACT", customerContact);
    }

    public String getCustomerPhone() {
        return (String)this.getProblemData().get("pdc_CUSTOMER_PHONE");
    }

    public void setCustomerPhone(String customerPhone) {
        this.getProblemData().add("pdc_CUSTOMER_PHONE", customerPhone);
    }

    public void setServicePhone(String servicePhone) {
        this.getProblemData().add("pdc_SERVICE_PHONE", servicePhone);
    }

    public String getServicePhoneNumber() {
        return (String)this.getProblemData().get("pdc_SERVICE_PHONE");
    }

    public String getStatus() {
        return (String)this.getProblemData().get("pdc_STATUS");
    }

    public void setStatus(String status) {
        Trace.trace(TRACE_MASKD, "set the status to be " + status);
        this.getProblemData().add("pdc_STATUS", status);
    }

    public boolean isPastProblemCorrelationDisabled() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_DISABLE_PPC");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return false");
        return false;
    }

    public void setPastProblemCorrelationDisabled(boolean value) {
        this.getProblemData().add("pdc_DISABLE_PPC", new Boolean(value));
    }

    public boolean isDisableRepair() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_DISABLE_RV");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return false");
        return false;
    }

    public void setDisableRepair(boolean disableRV) {
        this.getProblemData().add("pdc_DISABLE_RV", new Boolean(disableRV));
    }

    public void setSenseData(String senseData) {
        this.getProblemData().add("pdc_SENSE_DATA", senseData);
    }

    public String getSenseData() {
        return (String)this.getProblemData().get("pdc_SENSE_DATA");
    }

    public boolean hasSenseData() {
        return this.getProblemData().get("pdc_SENSE_DATA") != null;
    }

    public void setConcurrentRepair(int concurrent) {
        String stringConcurrent = String.valueOf(concurrent);
        this.getProblemData().add("pdc_CONCURRENT_REPAIR", new Integer(concurrent));
    }

    public int getConcurrentRepair() {
        if (this.getProblemData().get("pdc_CONCURRENT_REPAIR") != null) {
            return (Integer)this.getProblemData().get("pdc_CONCURRENT_REPAIR");
        }
        return 0;
    }

    public void setCategory(int category) {
        this.getProblemData().add("pdc_CATEGORY", new Integer(category));
    }

    public int getCategory() {
        if (this.getProblemData().get("pdc_CATEGORY") != null) {
            return (Integer)this.getProblemData().get("pdc_CATEGORY");
        }
        return 1;
    }

    public void setDescription(int descriptionID) {
        this.getProblemData().add("pdc_DESCRIPTION", new BaseMessageText("XPA" + String.valueOf(descriptionID)));
    }

    public void setDescription(BaseMessageText messageText) {
        this.getProblemData().add("pdc_DESCRIPTION", messageText);
    }

    public void setDescription(LocalizableText messageText) {
        this.getProblemData().add("pdc_DESCRIPTION", messageText);
    }

    public LocalizableText getDescription() {
        LocalizableText messageText = (LocalizableText)this.getProblemData().get("pdc_DESCRIPTION");
        if (messageText != null) {
            return messageText;
        }
        return new BaseMessageText("XPA1637");
    }

    public void addParts(XMLEncodeableArrayList fruList) {
        List existingFruList = (List)this.getProblemData().get("pdc_FRUS");
        if (existingFruList != null) {
            existingFruList.addAll(fruList);
        } else {
            this.getProblemData().add("pdc_FRUS", fruList);
        }
    }

    public void addPart(CommonPaFru fru) {
        List fruList = (List)this.getProblemData().get("pdc_FRUS");
        if (fruList != null) {
            fruList.add(fru);
        } else {
            fruList = new XMLEncodeableArrayList("FRU List");
            fruList.add(fru);
            this.getProblemData().add("pdc_FRUS", fruList);
        }
    }

    public void addFixDescription(String fixDescription) {
        this.getProblemData().add("pdc_FIX_DESCRIPTION", fixDescription);
    }

    public String getFixDescription() {
        return (String)this.getProblemData().get("pdc_FIX_DESCRIPTION");
    }

    public void addReplacedPart(CommonPaFru fru) {
        List replaceList;
        if (fru.getReplacedTimeStamp() == 0L) {
            fru.setReplacedTimeStamp(System.currentTimeMillis());
        }
        if ((replaceList = (List)this.getProblemData().get("pdc_REPLACED_FRUS")) != null) {
            replaceList.add(fru);
        } else {
            replaceList = new XMLEncodeableArrayList("Replaced FRU List");
            replaceList.add(fru);
            this.getProblemData().add("pdc_REPLACED_FRUS", replaceList);
        }
    }

    public List getReplacedParts() {
        return (List)this.getProblemData().get("pdc_REPLACED_FRUS");
    }

    public int getPartCount() {
        int count = 0;
        List fruList = (List)this.getProblemData().get("pdc_FRUS");
        if (fruList != null) {
            count = fruList.size();
        }
        return count;
    }

    public List getParts() {
        return (List)this.getProblemData().get("pdc_FRUS");
    }

    public void setEEDLocation(String eedLocation) {
        this.getProblemData().add("pdc_EED_LOCATION", eedLocation);
    }

    public String getEEDLocation() {
        return (String)this.getProblemData().get("pdc_EED_LOCATION");
    }

    public void setDumpLocation(String dumpLocation) {
        this.getProblemData().add("pdc_DUMP_LOCATION", dumpLocation);
    }

    public String getDumpLocation() {
        return (String)this.getProblemData().get("pdc_DUMP_LOCATION");
    }

    public void addProblemStatement(BaseMessageText problemStatement) {
        this.getAnalysisData().getProblemStatement().add(problemStatement);
    }

    public void addProblemStatement(LocalizableText problemStatement) {
        this.getAnalysisData().getProblemStatement().add(problemStatement);
    }

    public void addProblemStatement(int problemStatement) {
        this.getAnalysisData().getProblemStatement().add(new BaseMessageText("XPA" + String.valueOf(problemStatement)));
    }

    public void addCorrectiveActionStatement(int correctiveAction) {
        this.getAnalysisData().getProblemCorrectiveAction().add(new BaseMessageText("XPA" + String.valueOf(correctiveAction)));
    }

    public void addCorrectiveActionStatement(BaseMessageText correctiveAction) {
        this.getAnalysisData().getProblemCorrectiveAction().add(correctiveAction);
    }

    public void addCorrectiveActionStatement(LocalizableText correctiveAction) {
        this.getAnalysisData().getProblemCorrectiveAction().add(correctiveAction);
    }

    public void addRepairImpactStatement(int repairImpact) {
        this.getAnalysisData().getProblemRepairImpact().add(new BaseMessageText("XPA" + String.valueOf(repairImpact)));
    }

    public void addRepairImpactStatement(BaseMessageText repairImpact) {
        this.getAnalysisData().getProblemRepairImpact().add(repairImpact);
    }

    public void addRepairImpactStatement(LocalizableText repairImpact) {
        this.getAnalysisData().getProblemRepairImpact().add(repairImpact);
    }

    public HistoryEntry getServiceHistoryState() {
        List serviceHistory;
        HistoryEntry entry = new HistoryEntry(1);
        ServiceHistory sh = this.getServiceHistory();
        if (sh != null && (serviceHistory = sh.getHistory()) != null) {
            ListIterator listIterator = serviceHistory.listIterator();
            while (listIterator.hasNext()) {
                entry = (HistoryEntry)listIterator.next();
            }
        }
        return entry;
    }

    public String getProblemOrigin() {
        String origin = (String)this.getProblemData().get("pdc_PROBLEM_ORIGIN");
        if (origin == null) {
            origin = "UNKNOWN_SOURCE";
        }
        return origin;
    }

    public boolean isProblemClosed() {
        if (this.getProblemOrigin().equals("LEGAGY_LOCAL") || this.getProblemOrigin().equals("LEGAGY_REMOTE")) {
            Trace.trace(TRACE_MASKD, "Got a legacy problem");
            boolean stateValue = false;
            ServiceHistory servHist = this.getServiceHistory();
            if (servHist != null) {
                List shList = servHist.getHistory();
                ListIterator listIterator = shList.listIterator();
                while (listIterator.hasNext()) {
                    HistoryEntry entry = (HistoryEntry)listIterator.next();
                    int state = entry.getHistory();
                    Trace.trace(TRACE_MASKD, "got a state of " + state);
                    if (state < 32 || state > 47) continue;
                    stateValue = true;
                    break;
                }
                return stateValue;
            }
            return stateValue;
        }
        Trace.trace(TRACE_MASKD, "got a non legacy problem use the internal state (" + this.getProblemState() + ")");
        if (this.getProblemState() == 2) {
            Trace.trace(TRACE_MASKD, "closed");
            return true;
        }
        Trace.trace(TRACE_MASKD, "not closed");
        return false;
    }

    public LocalizableText getServiceHistoryStateLT() {
        BaseMessageText aBmt = null;
        aBmt = this.isProblemClosed() ? new BaseMessageText("XSH342") : new BaseMessageText("XSH341");
        return aBmt;
    }

    public void addFruList(CommonFruList fruList) {
        Trace.trace(TRACE_MASKD, "--> CommonProblem.addFruList()");
        if (fruList != null) {
            CommonPaFru[] aFruArray = fruList.getFrus();
            int i = 0;
            while (i < aFruArray.length) {
                this.addPart(aFruArray[i]);
                ++i;
            }
        } else {
            Trace.trace(TRACE_MASKD, "fruList was null");
        }
        Trace.trace(TRACE_MASKD, "<-- CommonProblem.addFruList()");
    }

    public void removeFruList() {
        this.getProblemData().remove("pdc_FRUS");
    }

    public void open() throws ProblemOpeningException {
        Trace.trace(TRACE_MASKF, "--> Common Problem.open()");
        Trace.trace(TRACE_MASKF, "open for refcode = " + this.getRefcode());
        Trace.trace(TRACE_MASKF, "get the addtional info");
        this.getAdditionalInfo();
    }

    public void setProblemState(int problemState) {
        block5: {
            block4: {
                Trace.trace(TRACE_MASKF, "set the problem state to be" + problemState);
                super.setProblemState(problemState);
                if (problemState != 1) break block4;
                Trace.trace(TRACE_MASKD, "set service history to be open");
                try {
                    this.serviceHistoryEvent(new HistoryEntry(1));
                }
                catch (Exception e) {
                    CommonPaLogger.logIt((short)4102, 0, e, true);
                }
                break block5;
            }
            if (problemState != 2) break block5;
            Trace.trace(TRACE_MASKD, "set service history to be closed");
            try {
                this.serviceHistoryEvent(new HistoryEntry(32));
            }
            catch (Exception e) {
                CommonPaLogger.logIt((short)4102, 1, e, true);
            }
        }
    }

    public final void serviceAuthorized() {
        Trace.trace(TRACE_MASKT, "--> serviceAuthorized()");
        if (DistributedAnalysisDomain.attemptProblemActionRedirection(this, "PART_DAD_PROB_SVC_AUTH")) {
            Trace.trace(TRACE_MASKT, "<-- serviceAuthorized()");
            return;
        }
        this.primaryServiceAuthorized();
        Trace.trace(TRACE_MASKT, "<-- serviceAuthorized()");
    }

    public void primaryServiceAuthorized() {
        Trace.trace(TRACE_MASKT, "--> primaryServiceAuthorized()");
        this.setServiceAuthorized(true);
        try {
            this.serviceHistoryEvent(new HistoryEntry(13));
        }
        catch (Exception e) {
            CommonPaLogger.logIt((short)4102, 3, e, true);
        }
        try {
            ProblemReporter problemRptr = (ProblemReporter)ServiceInterfaces.getFactory(this.getFailingSystem(), "ProblemReporter");
            problemRptr.reportProblem(this);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "<-- primaryServiceAuthorized()");
    }

    public final void serviceDeclined() {
        Trace.trace(TRACE_MASKT, "--> serviceDeclined()");
        if (DistributedAnalysisDomain.attemptProblemActionRedirection(this, "PART_DAD_PROB_SVC_DECL")) {
            Trace.trace(TRACE_MASKT, "<-- serviceDeclined()");
            return;
        }
        this.primaryServiceDeclined();
        Trace.trace(TRACE_MASKT, "<-- serviceDeclined()");
    }

    public void primaryServiceDeclined() {
        Trace.trace(TRACE_MASKT, "--> primaryServiceDeclined()");
        try {
            this.serviceHistoryEvent(new HistoryEntry(16));
            ProblemManager.getProblemManager().close(this);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Got an exception");
            Trace.trace(TRACE_MASKF, e);
            CommonPaLogger.logIt((short)4102, 4, e, true);
        }
        Trace.trace(TRACE_MASKT, "<-- primaryServiceDeclined()");
    }

    public final void serviceManual() {
        Trace.trace(TRACE_MASKT, "--> serviceManual()");
        if (DistributedAnalysisDomain.attemptProblemActionRedirection(this, "PART_DAD_PROB_SVC_MAN")) {
            Trace.trace(TRACE_MASKT, "<-- serviceManual()");
            return;
        }
        this.primaryServiceManual();
        Trace.trace(TRACE_MASKT, "<-- serviceManual()");
    }

    public void primaryServiceManual() {
        Trace.trace(TRACE_MASKT, "--> primaryServiceManual()");
        Trace.trace(TRACE_MASKT, "<-- primaryServiceManual()");
    }

    public void serviceHistoryEvent(HistoryEntry event) throws ProblemAnalysisException {
        Trace.trace(TRACE_MASKT, "--> serviceHistoryEvent(): state=" + event.getHistory());
        this.getServiceHistory().addHistory(event);
        Trace.trace(TRACE_MASKT, "<-- serviceHistoryEvent()");
    }

    public void serviceHistoryClose() throws ProblemAnalysisException, PropertyVetoException {
        try {
            ProblemManager.getProblemManager().close(this);
        }
        catch (PropertyVetoException exc) {
            Trace.trace(TRACE_MASKF, "got a property veto exception");
            throw exc;
        }
        catch (ProblemAnalysisException exc) {
            Trace.trace(TRACE_MASKF, "Got a Problem Manager closing exception");
            CommonPaLogger.logIt((short)1, 0, exc, false);
            throw exc;
        }
        this.serviceHistoryEvent(new HistoryEntry(33));
    }

    public void close() throws ProblemClosingException {
        Trace.trace(TRACE_MASKT, "--> CommonProblem.close");
        this.problemState = 2;
        this.setServiceAction(null);
        Trace.trace(TRACE_MASKT, "<-- CommonProblem.close");
    }

    public void addSurveillanceLinkFailure(SurveillanceLinkFailure link) {
        List survList = (List)this.getProblemData().get("pdc_SURV_LIST");
        if (survList != null) {
            survList.add(link);
        } else {
            survList = new XMLEncodeableArrayList("Surveillance Link List");
            survList.add(link);
            this.getProblemData().add("pdc_SURV_LIST", link);
        }
    }

    public List getSurveillanceLinkFailures() {
        return (List)this.getProblemData().get("pdc_SURV_LIST");
    }

    public void setFEDCKey(FEDCKey key) {
        this.getProblemData().add("FEDCKey", key);
    }

    public FEDCKey getFEDCKey() {
        FEDCKey key = (FEDCKey)this.getProblemData().get("FEDCKey");
        if (key == null) {
            Trace.trace(TRACE_MASKD, "got a null key. build one");
            String logClass = null;
            String logType = null;
            String refcode = this.getRefcode();
            String extension = this.getExtension();
            Object logId = null;
            CommonDataEvent theEvent = this.getPrimaryDataEvent();
            if (theEvent != null) {
                logId = this.getPrimaryDataEvent().getData();
            }
            if (logId != null && logId instanceof Log) {
                logClass = Integer.toHexString(0xFF & ((Log)logId).getLogClass());
                if (logClass.length() < 2) {
                    Trace.trace(TRACE_MASKD, "fix up the log class");
                    logClass = "0" + logClass;
                    Trace.trace(TRACE_MASKD, "the log class is now " + logClass);
                }
                if ((logType = Integer.toHexString(0xFF & ((Log)logId).getLogType())).length() < 2) {
                    Trace.trace(TRACE_MASKD, "fix up the log type");
                    logType = "0" + logType;
                    Trace.trace(TRACE_MASKD, "the log type is now " + logType);
                }
            }
            if (logClass != null && logType != null) {
                Trace.trace(TRACE_MASKD, "build the key to return");
                if (refcode == null) {
                    Trace.trace(TRACE_MASKD, "the refcode wasn't set. Set it to 00000000");
                    refcode = "00000000";
                }
                if (extension == null) {
                    Trace.trace(TRACE_MASKD, "the extension wasn't set. Set it to 00000000");
                    extension = "00000000";
                }
                key = new ConsoleFEDCKey(logClass, logType, refcode, extension);
            }
        }
        return key;
    }

    public void setUserdefinedID(int id) {
        this.getProblemData().add("pdc_UD_ID", new Integer(id));
    }

    public int getUserdefinedID() {
        if (this.getProblemData().get("pdc_UD_ID") != null) {
            return (Integer)this.getProblemData().get("pdc_UD_ID");
        }
        return Integer.MIN_VALUE;
    }

    public String dumpProblem() {
        Object value;
        String myKey;
        Iterator keyIterator;
        String output = "\nProblem Dump\n";
        output = output + "Description is " + this.getShortDescription() + "\n";
        output = output + "=====> Analysis Data\n \n \n";
        AnalysisData myAD = this.getAnalysisData();
        if (myAD != null) {
            LocalizableText myLT;
            List myList = myAD.getProblemStatement();
            output = output + "=====> Problem Statements\n";
            int j = 0;
            while (j < myList.size()) {
                myLT = (LocalizableText)myList.get(j);
                output = output + "text = " + myLT.toString() + "\n";
                ++j;
            }
            output = output + "=====> Corrective Actions\n";
            myList = myAD.getProblemCorrectiveAction();
            j = 0;
            while (j < myList.size()) {
                myLT = (LocalizableText)myList.get(j);
                output = output + "text = " + myLT.toString() + "\n";
                ++j;
            }
            output = output + "=====> Repair Impacts\n";
            myList = myAD.getProblemRepairImpact();
            j = 0;
            while (j < myList.size()) {
                myLT = (LocalizableText)myList.get(j);
                output = output + "text = " + myLT.toString() + "\n";
                ++j;
            }
            output = output + "=====> Analysis Data";
            KeyValuePairing keySet = myAD.getSummary();
            if (keySet != null) {
                keyIterator = keySet.keyIterator();
                while (keyIterator.hasNext()) {
                    myKey = (String)keyIterator.next();
                    value = keySet.get(myKey);
                    if (!(value instanceof NonLocalizablePanelValue)) continue;
                    output = output + "<K>" + myKey;
                    output = output + "<V>" + ((NonLocalizablePanelValue)value).getValue() + "</V></K>";
                }
            } else {
                output = output + "nokeyset values";
            }
        }
        output = output + "=====> Problem Data\n";
        ProblemData pdo = this.getProblemData();
        if (pdo != null) {
            keyIterator = pdo.keyIterator();
            while (keyIterator.hasNext()) {
                myKey = (String)keyIterator.next();
                value = pdo.get(myKey);
                if (!(value instanceof NonLocalizablePanelValue)) continue;
                output = output + "<K>" + myKey;
                output = output + "<V>" + ((NonLocalizablePanelValue)value).getValue() + "</V></K>";
            }
        }
        return output;
    }

    public String getProblemString() {
        Object value;
        String myKey;
        KeyValuePairing keySet;
        int k;
        Object[] vars;
        LocalizableText myLT;
        int j;
        List myList;
        String output = "<PROB>";
        output = output + "<Desc>" + this.getShortDescription() + "</Desc>";
        UserContext userContext = UserContext.getCurrentUserContext();
        DateFormat df = DateFormat.getDateInstance(2, userContext.getLocale());
        df.setTimeZone(userContext.getTimeZone());
        DateFormat tf = DateFormat.getTimeInstance(2, userContext.getLocale());
        tf.setTimeZone(userContext.getTimeZone());
        Date theDate = new Date(this.getProblemTimeStamp());
        output = output + "<Date>" + df.format(theDate);
        output = output + "</Date><Time>" + tf.format(theDate);
        output = output + "</Time>";
        AnalysisData myAD = this.getAnalysisData();
        output = output + "<AD><PS>";
        if (myAD != null) {
            myList = myAD.getProblemStatement();
            j = 0;
            while (j < myList.size()) {
                myLT = (LocalizableText)myList.get(j);
                output = output + "<S>" + myLT.getKey();
                vars = myLT.getSubstitutionData();
                if (vars != null) {
                    k = 0;
                    while (k < vars.length) {
                        output = output + "<V>" + (String)vars[k] + "</V>";
                        ++k;
                    }
                }
                output = output + "</S>";
                ++j;
            }
        }
        output = output + "</PS><CA>";
        if (myAD != null) {
            myList = myAD.getProblemCorrectiveAction();
            j = 0;
            while (j < myList.size()) {
                myLT = (LocalizableText)myList.get(j);
                output = output + "<S>" + myLT.getKey();
                vars = myLT.getSubstitutionData();
                if (vars != null) {
                    k = 0;
                    while (k < vars.length) {
                        output = output + "<V>" + (String)vars[k] + "</V>";
                        ++k;
                    }
                }
                output = output + "</S>";
                ++j;
            }
        }
        output = output + "</CA><RI>";
        if (myAD != null) {
            myList = myAD.getProblemRepairImpact();
            j = 0;
            while (j < myList.size()) {
                myLT = (LocalizableText)myList.get(j);
                output = output + "<S>" + myLT.getKey();
                vars = myLT.getSubstitutionData();
                if (vars != null) {
                    k = 0;
                    while (k < vars.length) {
                        output = output + "<V>" + (String)vars[k] + "</V>";
                        ++k;
                    }
                }
                output = output + "</S>";
                ++j;
            }
        }
        output = output + "</RI><SUM>";
        if (myAD != null && (keySet = myAD.getSummary()) != null) {
            Iterator keyIterator = keySet.keyIterator();
            while (keyIterator.hasNext()) {
                myKey = (String)keyIterator.next();
                value = keySet.get(myKey);
                if (value instanceof NonLocalizablePanelValue) {
                    output = output + "<" + myKey + ">";
                    output = output + ((NonLocalizablePanelValue)value).getValue() + "</" + myKey + ">";
                    continue;
                }
                if (!(value instanceof CaptionValuePairing)) continue;
                output = output + "<" + myKey + ">";
                CaptionValuePairing myCVP = (CaptionValuePairing)value;
                output = output + myCVP.getCaption().getKey();
                PanelValue panelValue = myCVP.getValue();
                if (panelValue instanceof NonLocalizablePanelValue) {
                    output = output + "<V>" + ((NonLocalizablePanelValue)panelValue).getValue() + "</V>";
                }
                output = output + "</" + myKey + ">";
            }
        }
        output = output + "</SUM></AD>";
        output = output + "<PROBDATA>";
        ProblemData pdo = this.getProblemData();
        if (pdo != null) {
            Iterator keyIterator = pdo.keyIterator();
            while (keyIterator.hasNext()) {
                myKey = (String)keyIterator.next();
                value = pdo.get(myKey);
                output = output + "<" + myKey + ">";
                if (value instanceof NonLocalizablePanelValue) {
                    output = output + ((NonLocalizablePanelValue)value).getValue() + "</" + myKey + ">";
                    continue;
                }
                if (myKey.equals("pdc_FRUS")) {
                    List fruList = (List)value;
                    j = 0;
                    while (j < fruList.size()) {
                        CommonPaFru aFRU = (CommonPaFru)fruList.get(j);
                        output = output + "<FRU>";
                        output = output + "<location>" + aFRU.getLocationList() + "</location>";
                        output = output + "<partnumber>" + aFRU.getPartNumber() + "</partnumber>";
                        output = output + "<serialnumber>" + aFRU.getSerialNumber() + "</serialnumber>";
                        output = output + "<percent>" + aFRU.getPercent() + "</percent>";
                        output = output + "<eclevel>" + aFRU.getECLevel() + "</eclevel>";
                        output = output + "</FRU>";
                        ++j;
                    }
                    output = output + "</" + myKey + ">";
                    continue;
                }
                if (value instanceof LocalizableText) {
                    myLT = (LocalizableText)value;
                    output = output + myLT.getKey();
                    vars = myLT.getSubstitutionData();
                    if (vars != null) {
                        int k2 = 0;
                        while (k2 < vars.length) {
                            output = output + "<VAR>" + (String)vars[k2] + "</VAR>";
                            ++k2;
                        }
                    }
                    output = output + "</" + myKey + ">";
                    continue;
                }
                output = output + value + "</" + myKey + ">";
            }
        }
        output = this.isProblemClosed() ? output + "<STATE>CLOSED</STATE>" : output + "<STATE>OPEN</STATE>";
        output = output + "</PROBDATA>";
        ServiceHistory sHist = this.getServiceHistory();
        if (sHist != null) {
            output = output + "<ServiceHistory>";
            List histList = sHist.getHistory();
            ListIterator listIterator = histList.listIterator();
            while (listIterator.hasNext()) {
                HistoryEntry entry = (HistoryEntry)listIterator.next();
                output = output + "<State" + entry.getHistory() + ">";
                df = DateFormat.getDateInstance(2, userContext.getLocale());
                df.setTimeZone(userContext.getTimeZone());
                tf = DateFormat.getTimeInstance(2, userContext.getLocale());
                tf.setTimeZone(userContext.getTimeZone());
                output = output + df.format(entry.getDate()) + ", ";
                output = output + tf.format(entry.getDate());
                output = output + "</State" + entry.getHistory() + ">";
            }
            output = output + "</ServiceHistory>";
        }
        output = output + "</PROB>";
        return output;
    }

    public String formatProblemString(String inString) {
        int start = 0;
        int index1 = 0;
        String output = "";
        do {
            if ((index1 = inString.indexOf("/", start)) == -1) continue;
            int index2 = inString.indexOf(">", index1);
            String tmpString = inString.substring(start, index2 + 1);
            output = output + tmpString + "\n";
            start = index2 + 1;
        } while (index1 != -1);
        return output;
    }

    public void setContextObject(Object contextObject) {
        this.contextObject = contextObject;
    }

    public Object getContextObject() {
        return this.contextObject;
    }

    public String toString() {
        StringBuffer problemSBuf = new StringBuffer(100);
        problemSBuf.append("Problem Class = ");
        problemSBuf.append(this.getClass() + "\n");
        problemSBuf.append("UUID = ");
        problemSBuf.append(this.getUniqueKey() + "\n");
        problemSBuf.append("Problem Number = ");
        problemSBuf.append(this.getProblemNumber() + "\n");
        problemSBuf.append("Sequence Number = ");
        problemSBuf.append(this.getSequenceNumber() + "\n");
        problemSBuf.append("Reporting Remote Machine System MTMS = ");
        if (this.getReportingRemoteMachineSystem() != null) {
            problemSBuf.append(this.getReportingRemoteMachineSystem().getMTMS() + "\n");
        } else {
            problemSBuf.append("not set\n");
        }
        problemSBuf.append("Primary Analyzing Console System MTMS = ");
        if (this.getPrimaryAnalyzingConsoleSystem() != null) {
            problemSBuf.append(this.getPrimaryAnalyzingConsoleSystem().getMTMS() + "\n");
        } else {
            problemSBuf.append("not set\n");
        }
        problemSBuf.append("Failing System MTMS = ");
        if (this.getFailingSystem() != null) {
            problemSBuf.append(this.getFailingSystem().getMTMS() + "\n");
        } else {
            problemSBuf.append("not set\n");
        }
        problemSBuf.append("Domain ID = ");
        if (this.getDomainId() != null) {
            problemSBuf.append(this.getDomainId() + "\n");
        } else {
            problemSBuf.append("not set\n");
        }
        problemSBuf.append("Refcode = ");
        problemSBuf.append(this.getRefcode() + "\n");
        problemSBuf.append("Extension = ");
        problemSBuf.append(this.getExtension() + "\n");
        String temp = this.getSecondaryRefcode();
        if (temp != null) {
            problemSBuf.append("Secondary Refcode = ");
            problemSBuf.append(temp + "\n");
        }
        if ((temp = this.getSecondaryExtension()) != null) {
            problemSBuf.append("Secondary Extension = ");
            problemSBuf.append(temp + "\n");
        }
        return problemSBuf.toString();
    }

    protected void getAdditionalInfo() {
        Trace.trace(TRACE_MASKD, "--> getAdditionalInfo");
        this.getCustomerInfo();
        this.getServiceInfo();
        this.getRSFInfo();
        if (this.getProblemType() == null) {
            Trace.trace(TRACE_MASKD, "set the problem type to be 1");
            this.setProblemType("1");
        }
        this.getFRUInfo();
    }

    protected void getCustomerInfo() {
        CustomerInfoData custInfo = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
        this.setCustomerContact(custInfo.getAdminName());
        this.setCustomerPhone(custInfo.getAdminPhone());
        Trace.trace(TRACE_MASKD, "customer contact = " + this.getCustomerContact());
        Trace.trace(TRACE_MASKD, "customer phone = " + this.getCustomerPhone());
    }

    protected void getServiceInfo() {
        RemoteServiceData rsd = RemoteServiceData.getRemoteServiceData();
        if (rsd != null) {
            this.setServicePhone(rsd.getServiceNumber());
        }
        Trace.trace(TRACE_MASKD, "service phone = " + this.getServicePhoneNumber());
    }

    protected void getRSFInfo() {
        if (!this.getSkipRSF()) {
            RemoteSupportFacility rsf = RsfManager.getRsfManager().getConsoleRsf();
            boolean RSFEnabled = false;
            if (rsf != null) {
                RSFEnabled = rsf.isCallHomeEnabled();
            }
            this.setRSFEnabled(RSFEnabled);
            Trace.trace(TRACE_MASKD, "RSF Enabled = " + this.isRSFEnabled());
        } else {
            Trace.trace(TRACE_MASKF, "skip the RSF data gathering");
            this.setRSFEnabled(false);
        }
    }

    protected void getFRUInfo() {
        block2: {
            if (!this.isResolveFruList()) break block2;
            try {
                Trace.trace(TRACE_MASKD, "get the fru list");
                HmcFruResolver sctm = new HmcFruResolver();
                HmcFruList frulist = (HmcFruList)sctm.resolve(this.getCommonFruListKey());
                Trace.trace(TRACE_MASKD, "add the fru list");
                this.addFruList(frulist);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKD, "got an exception resolving frus");
                Trace.trace(TRACE_MASKD, exc);
                CommonPaLogger.logIt((short)4100, 0, exc, true);
            }
        }
    }

    public PASystem getReportingRemoteMachineSystem() {
        return this.reportingRemoteMachineSystem;
    }

    public void setReportingRemoteMachineSystem(PASystem system) {
        this.reportingRemoteMachineSystem = system;
    }

    public PASystem getPrimaryAnalyzingConsoleSystem() {
        return this.primaryAnalyzingConsoleSystem;
    }

    public void setPrimaryAnalyzingConsoleSystem(PASystem system) {
        this.primaryAnalyzingConsoleSystem = system;
    }

    public PASystem getFailingSystem() {
        return this.failingSystem;
    }

    public void setFailingSystem(PASystem system) {
        this.failingSystem = system;
    }

    public int getDuplicateCount() {
        List fileList = (List)this.getProblemData().get("pdc_DUP_PROB_ID");
        if (fileList != null) {
            return fileList.size();
        }
        return 0;
    }

    public String[] getDuplicateProblemIds() {
        String[] returnArray = new String[]{};
        List fileList = (List)this.getProblemData().get("pdc_DUP_PROB_ID");
        if (fileList != null) {
            returnArray = fileList.toArray(new String[0]);
        }
        return returnArray;
    }

    public void addDuplicateProblemId(String uuId) {
        List fileList = (List)this.getProblemData().get("pdc_DUP_PROB_ID");
        if (fileList != null) {
            fileList.add(uuId);
        } else {
            fileList = new XMLEncodeableArrayList("Duplicate Problem ID List");
            fileList.add(uuId);
            this.getProblemData().add("pdc_DUP_PROB_ID", fileList);
        }
    }

    public void setServiceableEventCreationTimestamp(long ts) {
        this.getProblemData().add("pdc_CREATION_TIME", "" + ts);
    }

    public long getServiceableEventCreationTimestamp() {
        String ts = (String)this.getProblemData().get("pdc_CREATION_TIME");
        if (ts == null) {
            return this.getProblemTimeStamp();
        }
        return Long.parseLong(ts);
    }

    public void setFirstReportedTimestamp(String ts) {
        this.getProblemData().add("pdc_FIRST_REPORTED_TIME", ts);
    }

    public void setFirstReportedTimestamp(long ts) {
        this.getProblemData().add("pdc_FIRST_REPORTED_TIME", "" + ts);
    }

    public long getFirstReportedTimestamp() {
        String ts = (String)this.getProblemData().get("pdc_FIRST_REPORTED_TIME");
        if (ts == null) {
            return this.getProblemTimeStamp();
        }
        return Long.parseLong(ts);
    }

    public void setLastReportedTimestamp(String ts) {
        this.getProblemData().add("pdc_LAST_REPORTED_TIME", ts);
    }

    public void setLastReportedTimestamp(long ts) {
        this.getProblemData().add("pdc_LAST_REPORTED_TIME", "" + ts);
    }

    public long getLastReportedTimestamp() {
        String ts = (String)this.getProblemData().get("pdc_LAST_REPORTED_TIME");
        if (ts == null) {
            return this.getProblemTimeStamp();
        }
        return Long.parseLong(ts);
    }

    public boolean isManuallyInitiated() {
        Boolean value = (Boolean)this.getProblemData().get("pdc_MANUAL_CREATE");
        if (value != null) {
            return value;
        }
        Trace.trace(TRACE_MASKD, "value not set return true");
        return false;
    }

    public void setManuallyInitiated(boolean manual) {
        this.getProblemData().add("pdc_MANUAL_CREATE", new Boolean(manual));
    }

    public void localize() {
        PASystem remoteCSRef = this.getPrimaryAnalyzingConsoleSystem();
        if (remoteCSRef != null) {
            RemoteConsoleSystem localRCSRef = new RemoteConsoleSystem();
            localRCSRef.setMachineType(remoteCSRef.getMachineType());
            localRCSRef.setMachineModel(remoteCSRef.getMachineModel());
            localRCSRef.setMachineSerial(remoteCSRef.getMachineSerial());
            localRCSRef.setSystemName(remoteCSRef.getSystemName());
            this.setPrimaryAnalyzingConsoleSystem(localRCSRef);
        }
    }

    public void addCeComments(String ceName, String ceComment) {
        List ceCommentList = (List)this.getProblemData().get("pdc_CE_COMMENT_LIST");
        if (ceCommentList != null) {
            ceCommentList.add(new CeComment(ceName, ceComment));
        } else {
            ceCommentList = new XMLEncodeableArrayList("CE Comment List");
            ceCommentList.add(new CeComment(ceName, ceComment));
            this.getProblemData().add("pdc_CE_COMMENT_LIST", ceCommentList);
        }
    }

    public XMLEncodeableArrayList getCeComments() {
        return (XMLEncodeableArrayList)this.getProblemData().get("pdc_CE_COMMENT_LIST");
    }

    public void setServiceableEventText(String svcEventText) {
        this.getProblemData().add("pdc_SVC_EVENT_TEXT", svcEventText);
    }

    public String getServiceableEventText() {
        return (String)this.getProblemData().get("pdc_SVC_EVENT_TEXT");
    }

    public void setSecondaryReportingSystem(PASystem system) {
        this.secondaryReportingSystem = system;
    }

    public PASystem getSecondaryReportingSystem() {
        return this.secondaryReportingSystem;
    }

    public static void main(String[] args) {
        Log aLog = new Log(-86, 35, 1, null, null, null, null, null);
        CommonDataEvent anEvent = new CommonDataEvent(new Object());
        anEvent.setData(aLog);
        CommonProblem aProblem = new CommonProblem();
        aProblem.setPrimaryDataEvent(anEvent);
        aProblem.setRefcode("refcode");
        aProblem.setExtension("extension");
        ConsoleFEDCKey aKey = (ConsoleFEDCKey)aProblem.getFEDCKey();
        Trace.trace(TRACE_MASKD, "the location is" + aKey.getLocation());
        Trace.trace(TRACE_MASKD, "the log class is" + aKey.getLogClass());
        System.out.println("key.location is" + aKey.getLocation());
        System.out.println("key.logclass is" + aKey.getLogClass());
        System.out.println("done");
    }

    private static class CommonProblemPersistentData
    implements PersistentData {
        private static final long serialVersionUID = 1L;
        public Object rrmsPersistentData = null;
        public Object pacsPersistentData = null;
        public Object fsPersistentData = null;
        public PersistentData superClassPersistentData = null;
        public int version = 1;

        private CommonProblemPersistentData() {
        }
    }
}

